import r2pipe
import base64
import socket
import re 

def valid_url(string): 
    url = re.findall('http[s]?://(?:[a-zA-Z]|[0-9]|[$-_@.&+]|[!*\(\), ]|(?:%[0-9a-fA-F][0-9a-fA-F]))+', string) 
    return url 

def valid_ip(address):
    try: 
        socket.inet_aton(address)
        return True
    except:
        return False

r = r2pipe.open("Unpacked_Lab01-02.exe")
r.cmd('aaa')
print (chr(27) + "[1;36m" + "\t\t\t\t\tSTAGE 1 - RECON: Getting information about Sections" + chr(27) + "[0m")
out = r.cmdj('iSj')
for i in range(len(out)):
    print(out[i]["name"])
    print("[+] Virtual Size: %i"%out[i]["vsize"])
    print("[+] Raw Data Size: %i"%out[i]["size"])
    print("[+] Permission: %s"%out[i]["perm"])

print (chr(27) + "[1;36m" + "\t\t\t\t\tSTAGE 1 - RECON: Getting information from Strings in PE File" + chr(27) + "[0m")
out = r.cmdj('izj')
print("[+] Strings from binary:")
for i in range(len(out)):
    encoded_ = out[i]["string"]   #All base64 strings
    strings = base64.b64decode(encoded_)
    print(strings)
    if strings == "KERNEL32.dll" or strings == "KERNEL32.DLL":
        print (chr(27) + "[0;33m" + "[+] Suggestion: If we look imports from %s probably we see functions for opening and manipulating files"%strings + chr(27) + "[0m")
    elif strings == "FindNextFileA" or strings == "FindFirstFileA":
        print (chr(27) + "[0;33m" + "[+] Suggestion: %s function tell us that probably the malware searches through the filesystem, and that i can open and modify files"%strings + chr(27) + "[0m")
    elif strings == ".exe":
        print (chr(27) + "[0;33m" + "[+] Suggestion: %s string maybe it will search for executables on the victim's system"%strings + chr(27) + "[0m")
    elif strings == "CreateProcessA" or strings == "Sleep":
        print (chr(27) + "[0;33m" + "[+] Suggestion: %s function imported from Kernel32.dll which are commonly used by backdoors"%strings + chr(27) + "[0m")
    elif strings == "WS2_32.dll":
        print (chr(27) + "[0;33m" + "[+] Suggestion: %s probably connects to a network or performs network-related tasks"%strings + chr(27) + "[0m")
    elif strings == "exec":
        print (chr(27) + "[0;33m" + "[+] Suggestion: %s string is probably sent over the network to command the backdoor to run a program with CreateProcess"%strings + chr(27) + "[0m")
    elif strings == "sleep":
        print (chr(27) + "[0;33m" + "[+] Suggestion: %s string is probably used to command the backdoor program to sleep"%strings + chr(27) + "[0m")
    elif valid_ip(strings) == True:
        print (chr(27) + "[0;33m" + "[+] Suggestion: %s this IP Address should be routable and it would be a good network-based indicator for use in identifying probably malware"%strings + chr(27) + "[0m")
    elif strings == "WININET.dll":
        print (chr(27) + "[0;33m" + "[+] Suggestion: Imports from %s tell us that this code connects to the Internet"%strings + chr(27) + "[0m")
    elif strings == "ADVAPI32.dll":
        print (chr(27) + "[0;33m" + "[+] Suggestion: Imports from %s tell us that the code creates a service"%strings + chr(27) + "[0m")
    try:
        if valid_url(strings)[0] == strings:
            print (chr(27) + "[0;33m" + "[+] Suggestion: URL %s probably opened by InternetOpenURL function"%strings + chr(27) + "[0m")
    except IndexError:
        pass
